#!/bin/sh

TARGET="$HOME/bin/AssetUPnP"

RUNME=$TARGET/AssetUPnP

echo "=== AssetUPnP uninstaller ==="

while true; do
	read -p "Are you sure you want to uninstall Asset UPnP? " yn
	case $yn in
		[Yy]* ) break;;
		[Nn]* ) exit;;
		* ) echo "Please answer yes or no.";;
	esac
done

"$RUNME" --shutdown

echo "Uninstalling..."

rm -rf "$TARGET"
rm -rf ~/.dBpoweramp

echo "Uninstalled."

CRONTAB=/tmp/asset-crontab.txt

crontab -l | fgrep -v "$TARGET" > "$CRONTAB"
# NOTE: the above might produce a blank crontab, which is still a legitimate behavior
# We used to have:
# crontab -l | fgrep -v "$TARGET" > "$CRONTAB" && crontab "$CRONTAB"
# but that doesn't work if the crontab becomes blank!
crontab "$CRONTAB"
rm -f "$CRONTAB"
